$ = jQuery;
var data = {
  list: {
    playlist_name: false,
    tracks: false,
    type: false,
    random_order: "",
  },
  currentTrack: 0,
  playlistID: "",
  showList: false,
  isPlaying: false,
  audioplayerPlaying: 0, //Which Audioplayer instance is playing.
  loading: 0,
  minimize: true,
  wavesurfer: false,
  audioCtx: false,
  audioElement: false,
  audioSrc: false,
  analyser: false,
  frequencyData: false,
  userPref: {
    pause: false,
    minimize: false,
    autoplay: true,
  },
  unlock: false,
  playerStatus: "",
  currentTime: "",
  totalTime: "",
  shuffle: false,
  mute: false,
  volume: 1,
  elWidgetId: false, //Only has value when the playlist is built with the elementor widget
  postId: false, //Used by the continous player when the playlist is generated by a elementor widget
  classes: {
    enable: false,
    waveEnable: false,
    wavesurferEnable: Boolean(sonaar_music.option.waveformType === "wavesurfer"),
    continuousPlayer: Boolean(sonaar_music.option.enable_continuous_player === "true"),
    isPlaying: false,
    playlist: iron_vars.sonaar_music.continuous_playlist_icon,
    author: iron_vars.sonaar_music.continuous_artist_name,
    feedUrl: false,
    notrackskip: false,
    continued: false, //Player settings come from the cookie (continuous player)
    dontCountContinuous: false, //For statistic. Dont count stats from the continuous player
    emptyPlayer: true,
  },
  cookieSetting: {
    mute: false,
    volume: 1,
    isPlaying: false,
    currentTime: 0,
  },
  css: {
    progressColor: {
      background: "" + iron_vars.sonaar_music.continuous_progress_bar + "",
      width: "0",
    },
    wavecut: {
      width: "0",
    },
    waveColor: {
      background: "" + iron_vars.sonaar_music.continuous_timeline_background + "",
      opacity: "0.5",
    },
    volumeHandle: {
      height: "100%",
    },
  },
};

var playerHasPlayed = false;

/*function webAudioTouchUnlock (context){
  return new Promise(function (resolve, reject){
    if (context.state === 'suspended'){
      var unlock = function(){
        context.resume().then(function(){
          document.body.removeEventListener('touchstart', unlock)
          document.body.removeEventListener('touchend', unlock)
          document.body.removeEventListener('click', unlock)
          document.body.removeEventListener('mousedown', unlock)

          resolve(true)
        }, 
        function (reason){
          reject(reason)
        })
      }

      document.body.addEventListener('touchstart', unlock, false)
      document.body.addEventListener('touchend', unlock, false)
      document.body.addEventListener('click', unlock, false)
      document.body.addEventListener('mousedown', unlock, false)
    }else{
      resolve(false)
    }
  })
}*/

var AudioContext = window.AudioContext || window.webkitAudioContext;
var sonaarAudioContext = new AudioContext();

IRON.sonaar = {
  player: new Vue({
    el: "#sonaar-player",
    data: data,
    methods: {
      play: function () {
        this.userPref.autoplay = true;
        if (this.isPlaying) {
          if (this.classes.wavesurferEnable) {
            this.wavesurfer.pause(); // --WaveSurfer Sticky player
          } else {
            document.getElementById("sonaar-audio").pause(); // -- Audio MediaElement
          }
        } else {
          this.playAudio();
        }
      },
      playAudio: function () {
        if (this.classes.wavesurferEnable) {
          IRON.sonaar.player.wavesurfer.play();
        } else {
          var promise = document.getElementById("sonaar-audio").play();
          if (promise !== undefined) {
            promise
              .then((_) => {
                //console.log('play started! yeah');
                // Autoplay started!
              })
              .catch((error) => {
                console.log("error");
                // Autoplay was prevented.
                // Show a "Play" button so that user can start playback.
              });
          }
        }
      },
      previous: function () {
        if (this.shuffle) {
          var i;
          for (i = 0; i < this.list.random_order.length; i++) {
            if (this.list.random_order[i] == this.currentTrack) {
              if (i == 0) {
                this.currentTrack = this.list.random_order[this.list.random_order.length - 1];
              } else {
                this.currentTrack = this.list.random_order[i - 1];
              }
              break;
            }
          }
        } else {
          if (this.currentTrack - 1 < 0) return (this.currentTrack = this.list.tracks.length - 1);

          this.currentTrack--;
        }
      },
      next: function () {
        if (this.playerStatus == "next") return;

        if (this.shuffle) {
          var i;
          for (i = 0; i < this.list.random_order.length; i++) {
            if (this.list.random_order[i] == this.currentTrack) {
              if (i == this.list.random_order.length - 1) {
                this.currentTrack = this.list.random_order[0];
              } else {
                this.currentTrack = this.list.random_order[i + 1];
              }
              break;
            }
          }
        } else {
          if (this.currentTrack + 1 >= this.list.tracks.length) return (this.currentTrack = 0);

          this.currentTrack++;
        }
      },
      skip: function (time) {
        this.wavesurfer.seekTo(time);
      },

      setPlaylist: function (audioPlayer, eq) {
        if ($(audioPlayer).attr("trackselected") == eq || ($(audioPlayer).attr("trackselected") == null && eq == 0)) {
          $(audioPlayer).attr("duplicating_wave", true);
        }
        $(audioPlayer).attr("trackselected", eq);

        var params = audioPlayer.data("url-playlist").slice(audioPlayer.data("url-playlist").indexOf("title")).split("&");
        var title = params[0].slice(6);
        var feed = params[3].slice(5).length;

        if (feed) {
          var id = $(audioPlayer).attr("id"); //Use the elementor widget ID as the player ID. This param is only available the FEED option.
        } else {
          var id = params[1].slice(7);
        }

        this.setPlayer({
          id: id,
          title: title,
          trackid: eq,
          shuffle: audioPlayer.data("shuffle"),
          audioPlayer: audioPlayer,
        });
      },

      preventContinuousUrl: function () {
        var preventURL = false;
        if (typeof sonaar_music.option.sr_prevent_continuous_url !== "undefined" && sonaar_music.option.sr_prevent_continuous_url.length > 1) {
          var url_to_avoid = [];
          el_url = sonaar_music.option.sr_prevent_continuous_url.split("\r\n").filter(Boolean);
          url_to_avoid = [...url_to_avoid, ...el_url];
          $.each(url_to_avoid, function () {
            if (window.location.href.indexOf(this) > -1) {
              // do not play the audio because this page url is in the prevent list
              preventURL = true;
            }
          });
        }
        return preventURL;
      },

      setPlayerAndPlay: function (args) {
        IRON.audioPlayer.stickyEnable = true;
        this.setPlayer(args);
        if (IRON.sonaar.player.playlistID != args.id) {
          if (!this.classes.wavesurferEnable) {
            this.playAudio();
          }
        } else {
          this.play();
        }
      },

      getPlaylistbyID: function (id, title, elwidget) {
        var playlistID = id || false;
        var title = title || "";
        var elwidget = elwidget ? elwidget + "&feed=1" : null;
        if (playlistID) {
          if (this.selectedPlayer === null) {
            return iron_vars.site_url + "?load=playlist.json&title=" + title + "&albums=" + playlistID + "&el_widget_id=" + elwidget;
          } else {
            json_url = this.selectedPlayer.attr("data-url-playlist");
            return json_url;
          }
        }

        return false;
      },

      setPlayer: function (args) {
        this.classes.emptyPlayer = false;
        var args = args || {};

        this.shuffle = args.shuffle == true || args.shuffle == "true" || args.shuffle == "1" ? true : false;

        var params = {
          id: args.id || iron_vars.sonaar_music.currentPostId,
          title: args.title || null,
          trackid: args.trackid || 0,
          autoplay: typeof args.autoplay == "boolean" ? args.autoplay : true,
          time: args.time || false,
          el_widget_id: args.elwidgetid || false,
        };

        this.selectedPlayer = args.audioPlayer || null;
        this.elWidgetId = params.el_widget_id;

        $(".sr_selectedPlayer").removeClass("sr_selectedPlayer");
        $(this.selectedPlayer).addClass("sr_selectedPlayer");
        if (!this.classes.wavesurferEnable) {
          IRON.audioPlayer.fakeWaveClick("sticky");
        }
        this.userPref.autoplay = params.autoplay;

        if (params.id && params.id === this.playlistID && params.trackid == this.currentTrack) return this.play();

        if (params.id && params.id === this.playlistID && params.trackid !== this.currentTrack) {
          this.currentTrack = params.trackid;
        }

        if (params.id && params.id !== this.playlistID) {
          $.when($.getJSON(this.getPlaylistbyID(params.id, params.title, params.el_widget_id))).done(
            function (data) {
              if (!$("body").hasClass("artistPlayer-enable")) {
                this.classes.enable = true;
                if (!IRON.sonaar.player.classes.continued) {
                  this.minimize = false;
                }
                this.animatePlayer();
                $("body").addClass("continuousPlayer-enable");
              }

              this.list = data;

              if (this.shuffle) {
                this.setRandomList();
                if (typeof args.trackid == "undefined") {
                  params.trackid = Math.floor(Math.random() * this.list.tracks.length);
                }
              }

              this.playlistID = params.id;

              if (this.list.type == "podcast") {
                for (var i = 0; i < this.list.tracks.length; i++) {
                  var element = this.list.tracks[i];

                  if (element.id == params.id) {
                    this.currentTrack = i;
                  }
                }
              } else {
                this.currentTrack = params.trackid;
              }

              if (params.time) {
                this.skip(params.time);
              }

              if (this.currentTrack == 0) {
                //If the currentTrack still has the default value, execute handleTrackChange. HandletrackChange function is automatically triggered when the currentTrack value is changed.
                this.handleTrackChange();
              }
            }.bind(this)
          );
        }
        if (this.selectedPlayer != null) {
          this.classes.feedUrl = this.selectedPlayer.data("feedurl");
          this.classes.notrackskip = this.selectedPlayer.data("notrackskip");
        }
        this.postId = iron_vars.sonaar_music.currentPostId;
      },

      setAudio: function () {
        //Set to "audioplayerPlaying" which audioplayer is playing. ( 0 for the first audioplayer)
        var audioplayerPlayingID = null;
        $.each(IRON.players, function (index) {
          if ($(IRON.players[index].audioPlayer).hasClass("sr_selectedPlayer")) {
            audioplayerPlayingID = index;
          }
        });
        this.audioplayerPlaying = audioplayerPlayingID;
        //----------------------------------------------------------------------

        if (this.list.tracks[this.currentTrack].mp3 === null || this.list.tracks[this.currentTrack].mp3 === "") {
          // feed url is used in the shortcode instead of post id
          this.list.tracks[this.currentTrack].mp3 = $(".iron-audioplayer.sr_selectedPlayer li").attr("data-audiopath");
          this.list.tracks[this.currentTrack].track_title = $(".iron-audioplayer.sr_selectedPlayer li").attr("data-tracktitle");
          this.list.tracks[this.currentTrack].album_title = "";
        }

        elementAudio.src = this.list.tracks[this.currentTrack].mp3;
        $("#sonaar-player").attr("data-tracktitle", this.list.tracks[this.currentTrack].track_title);
        $("#sonaar-player").attr("data-audiopath", this.list.tracks[this.currentTrack].mp3);
        if (this.list.tracks[this.currentTrack].id != null) {
          $("#sonaar-player").attr("data-trackid", this.list.tracks[this.currentTrack].id);
        }
        if (this.classes.wavesurferEnable) {
          this.wavesurfer.load(elementAudio); //Load WAVESURFER to the Sticky player
          this.wavesurfer.pause();
          if (IRON.players.length != 0 && this.audioplayerPlaying != null) {
            IRON.players[this.audioplayerPlaying].wavesurfer.load(elementAudio); //Load WAVESURFER to the right audioplayer element
          }
        } else {
          $("#sonaar-player .sonaar_wave_cut, .sr_selectedPlayer .sonaar_wave_cut, #sonaar-player .mobileProgressing.wave-cut").width(0);
          var trackHasEnded = document.getElementById("sonaar-audio").ended;
          var isPlaying = !document.getElementById("sonaar-audio").paused;
          $("#sonaar-audio").attr("src", elementAudio.src); //Load Audio MediaElement to the Sticky player
          document.getElementById("sonaar-audio").load();
          if ($(".sr_selectedPlayer").length || isPlaying || trackHasEnded) {
            // if the sticky player is sync with a widget player OR is already playing
            this.playAudio();
            $("#sonaar-player .play").addClass("audio-playing");
          }
          this.classes.waveEnable = true;
          IRON.audioPlayer.createFakeWave(this.selectedPlayer);
        }
        $(document).trigger("sonaarStats", $("#sonaar-player"));
        if (IRON.players.length != 0 && this.classes.feedUrl && !this.elWidgetId && this.audioplayerPlaying != null) {
          //Set "elWidgetId" only when the playlist is built with the elementor widget
          this.elWidgetId = $(IRON.players[this.audioplayerPlaying].audioPlayer).parents(".elementor-widget-music-player").attr("data-id");
        }

        if (this.classes.continuousPlayer) {
          sr_setCookieSettings();
        }
      },
      setshowList: function () {
        if (this.showList == false) {
          $("#pusher-wrap").addClass("sonaar-list-active");
          return (this.showList = true);
        }

        $("#pusher-wrap").removeClass("sonaar-list-active");
        return (this.showList = false);
      },
      closePlayer: function () {
        if (this.showList) {
          $("#pusher-wrap").removeClass("sonaar-list-active");
          this.showList = false;
        }
        this.minimize = !this.minimize;
        this.classes.enable = !this.classes.enable;
        this.animatePlayer();
      },
      playlistAfterEnter: function () {
        var ps = new PerfectScrollbar("#sonaar-player .playlist .scroll", {
          wheelSpeed: 0.7,
          swipeEasing: true,
          wheelPropagation: false,
          minScrollbarLength: 20,
          suppressScrollX: true,
        });
        /*$('#sonaar-player .playlist .scroll').perfectScrollbar({
          'suppressScrollX': true
        })*/
      },
      scroll: function (event) {
        var el = event.target;
        var parent = el.offsetParent;

        if (el.offsetWidth > parent.offsetWidth && !el.classList.contains("scrolling")) {
          el.classList.add("scrolling");
          var transformWidth = el.offsetWidth + 10;
          el.insertAdjacentHTML("beforeend", '<span class="duplicate">' + el.innerText + "</span>");
          el.style.transform = "translate( -" + transformWidth + "px )";
          setTimeout(function () {
            el.classList.remove("scrolling");
            el.style.transform = "";
            el.removeChild(el.firstElementChild);
          }, 6000);
        }
      },
      updatePlayers: function () {
        if (IRON.players.length == 0 || this.selectedPlayer == null) {
          return;
        }
        $(".iron-audioplayer").removeClass("audio-playing");

        this.selectedPlayer.find("li.current").removeClass("current");

        if (this.isPlaying) {
          var currentTrackPlaying = this.currentTrack;
          var currentTrackTitle;
          this.selectedPlayer.addClass("audio-playing");
          this.selectedPlayer.find("li").eq(currentTrackPlaying).addClass("current");
          currentTrackTitle = this.selectedPlayer.find("li").eq(this.currentTrack).attr("data-tracktitle");
          IRON.audioPlayer.updatePlaylistTitle(this.selectedPlayer, this.selectedPlayer.find("li").eq(this.currentTrack).attr("data-albumtitle"));
          if (this.audioplayerPlaying != null) {
            $(IRON.players[this.audioplayerPlaying].audioPlayer).find(".track-title").html(currentTrackTitle);
          }
          return;
        }
      },

      skipTo: function (event) {
        this.skip(event.layerX / event.target.clientWidth);
      },

      setSlideVolume: function () {
        $(this.$el)
          .find(".volume .slide")
          .slider({
            orientation: "vertical",
            range: "min",
            min: 0,
            max: 100,
            value: 100,
            slide: function (event, ui) {
              IRON.sonaar.player.setVolume(ui.value / 100);
              IRON.sonaar.player.setMute(false);
            },
          });
      },

      setVolume: function (value) {
        IRON.sonaar.player.volume = value;
        if (this.classes.continuousPlayer) {
          sr_setCookieSettings();
        }
        if (this.classes.wavesurferEnable) {
          IRON.sonaar.player.wavesurfer.setVolume(value);
        } else {
          document.getElementById("sonaar-audio").volume = value;
        }
      },

      setMute: function (value) {
        if (this.classes.wavesurferEnable) {
          this.wavesurfer.setMute(value);
        } else {
          document.getElementById("sonaar-audio").muted = value;
        }
        this.mute = value;
        if (this.classes.continuousPlayer) {
          sr_setCookieSettings();
        }
      },

      muteTrigger: function () {
        if (this.mute) {
          this.setMute(false);
        } else {
          this.setMute(true);
        }
      },

      enableRandomList: function () {
        if (this.shuffle) {
          this.shuffle = false;
        } else {
          this.shuffle = true;
          this.setRandomList();
        }
        if (this.classes.continuousPlayer) {
          sr_setCookieSettings();
        }
      },

      showCTA: function () {
        if ($("#sonaar-player.enable .store").hasClass("opened")) {
          $("#sonaar-player.enable .store").removeClass("opened");
        } else {
          $("#sonaar-player.enable .store").addClass("opened");
        }
      },

      setRandomList: function () {
        this.list.random_order = IRON.audioPlayer.setRandomList(this.list.tracks);
      },

      setIsPlaying: function (value) {
        this.isPlaying = value;
        if (this.classes.continuousPlayer) {
          sr_setCookieSettings();
        }
      },

      handleTrackChange: function () {
        //This function is automatically triggered when the currentTrack value is changed.
        this.isPlaying = false;
        this.classes.waveEnable = false;
        if (this.classes.wavesurferEnable) {
          this.wavesurfer.drawer.clearWave();
        }
        this.setAudio();
        this.updatePlayers();
      },

      animatePlayer: function () {
        //animation when we click on the close button or when the player is loaded
        if (this.classes.continued) {
          if (!this.minimize) {
            $("#sonaar-player").css("bottom", "0");
          }
          this.classes.continued = false;
        } else {
          if (this.minimize) {
            bottomPosition = "-90px";
          } else {
            bottomPosition = "0";
          }
          $("#sonaar-player").animate({
            bottom: bottomPosition,
          });
        }
      },
    },

    computed: {
      classType: function () {
        return "list-type-" + this.list.type;
      },
      playerCallToAction: function () {
        if (this.list.type == "podcast") {
          return this.list.tracks[this.currentTrack].podcast_calltoaction;
        } else {
          return this.list.tracks[this.currentTrack].song_store_list;
        }
      },
      albumStoreList: function () {

        var song_store = this.list.tracks[this.currentTrack].song_store_list;
        var album_store = this.list.tracks[this.currentTrack].album_store_list;
        var storesObjects = [];

        if (song_store.length < 1 || song_store.length === false) {
          storesObjects = album_store !== undefined ? album_store : [];
        } else {
          storesObjects = album_store === false ? song_store : song_store.concat(album_store);
        }

        return storesObjects;
      },
      hasArtwork: function () {
        var strURL = this.list.tracks[this.currentTrack].poster;

        if (strURL != null && strURL != false) {
          return !strURL.endsWith("default.png");
        }
      },
      hideDuration: function () {
        if (this.list.type == "podcast" && iron_vars.sonaar_music.podcast_hide_duration != false) {
          return true;
        } else {
          return false;
        }
      },
      hideCategory: function () {
        if (this.list.type == "podcast" && iron_vars.sonaar_music.podcast_hide_category != false) {
          return true;
        } else {
          return false;
        }
      },
      playListTitle: function () {
        if (this.selectedPlayer && this.selectedPlayer.attr("data-playlist_title").length) {
          this.list.playlist_name = this.selectedPlayer.attr("data-playlist_title");
        }
        if (this.list.playlist_name == "") {
          return this.list.tracks[this.currentTrack].album_title;
        } else {
          return this.list.playlist_name;
        }
      },
    },
    mounted: function () {
      this.$nextTick(function () {
        if (!this.classes.wavesurferEnable) {
          // Audio MediaElement

          $("#sonaar-audio").on("timeupdate", function () {
            $("#sonaar-player .sonaar_wave_cut, .sr_selectedPlayer .sonaar_wave_cut, #sonaar-player .mobileProgressing.wave-cut").width((this.currentTime / this.duration) * 100 + "%");
            $("#sonaar-player .progressDot").css("left", (this.currentTime / this.duration) * 100 + "%");
            var sonaarAudio = document.getElementById("sonaar-audio");
            if (sonaarAudio.ended) {
              //When track ended
              if (IRON.sonaar.player.classes.notrackskip !== "on") {
                IRON.sonaar.player.next();
              }
            }
            var currentTime = sonaarAudio.currentTime;
            var time = moment.duration(currentTime, "seconds");
            // Update the Sticky player currentTime
            if (time.hours() >= 12 || time.hours() <= 0) {
              IRON.sonaar.player.currentTime = moment(time.minutes() + ":" + time.seconds(), "m:s").format("mm:ss");
            } else {
              IRON.sonaar.player.currentTime = moment(time.hours() + ":" + time.minutes() + ":" + time.seconds(), "h:m:s").format("h:mm:ss");
            }

            if (sonaarAudio.duration !== Infinity) {
              var timeLeft = moment.duration(sonaarAudio.duration - sonaarAudio.currentTime, "seconds");
              // Update the Sticky player timeLeft
              if (timeLeft.hours() >= 12 || timeLeft.hours() <= 0) {
                IRON.sonaar.player.totalTime = "-" + moment(timeLeft.minutes() + ":" + timeLeft.seconds(), "m:s").format("mm:ss");
              } else {
                IRON.sonaar.player.totalTime = "-" + moment(timeLeft.hours() + ":" + timeLeft.minutes() + ":" + timeLeft.seconds(), "h:m:s").format("h:mm:ss");
              }
            } else {
              IRON.sonaar.player.totalTime = "";
            }
            $(".sr_selectedPlayer .currentTime").html(IRON.sonaar.player.currentTime); // Update the widget player currentTime
            $(".sr_selectedPlayer .totalTime").html(IRON.sonaar.player.totalTime); // Update the widget player timeLeft
            sr_setCookieTime();
          });

          $("#sonaar-audio").on(
            "play",
            function () {
              this.playerStatus = "play";
              this.setIsPlaying(true);
            }.bind(this)
          );

          $("#sonaar-audio").on(
            "pause",
            function () {
              this.setIsPlaying(false);
              this.userPref.pause = true;
            }.bind(this)
          );
        }

        this.frequencyData = new Uint8Array(170);
        if (this.classes.wavesurferEnable) {
          // WaveSurfer

          this.wavesurfer = Object.create(window.WaveSurfer);
          this.wavesurfer.init({
            audioContext: sonaarAudioContext,
            container: "#sPlayer",
            cursorWidth: 0,
            barWidth: 1,
            progressColor: sonaar_music.option.sticky_player_soundwave_progress_bars,
            waveColor: sonaar_music.option.sticky_player_soundwave_bars,
            height: 36,
            backend: "MediaElement",
            mediaControls: false,
            partialRender: true,
            pixelRatio: 2,
            mediaType: "audio",
            responsive: true,
          });

          this.wavesurfer.on(
            "ready",
            function () {
              if (!playerHasPlayed) {
                playerHasPlayed = true;

                //set settings from cookie
                sr_setVolumeSliderManually(this.cookieSetting.volume);
                this.setMute(this.cookieSetting.mute);
                if (this.cookieSetting.isPlaying) {
                  this.playAudio();
                }
                if (this.cookieSetting.currentTime <= sr_getTrackDuration() && sr_getTrackDuration() != "Infinity") {
                  IRON.sonaar.player.wavesurfer.seekTo(parseFloat(this.cookieSetting.currentTime) / IRON.sonaar.player.wavesurfer.getDuration());
                }
                //END set settings from cookie
              } else {
                this.playAudio();
              }
            }.bind(this)
          );

          this.wavesurfer.on(
            "waveform-ready",
            function () {
              this.classes.waveEnable = true;
            }.bind(this)
          );

          this.wavesurfer.on(
            "play",
            function () {
              this.playerStatus = "play";
              this.setIsPlaying(true);
            }.bind(this)
          );

          this.wavesurfer.on(
            "pause",
            function () {
              this.setIsPlaying(false);
              this.userPref.pause = true;
            }.bind(this)
          );

          this.wavesurfer.on(
            "finish",
            function () {
              if (IRON.sonaar.player.classes.notrackskip) return;
              this.next();
              this.playerStatus = "next";
            }.bind(this)
          );

          this.wavesurfer.on(
            "loading",
            function () {
              this.loading = arguments[0];
            }.bind(this)
          );

          this.wavesurfer.on(
            "audioprocess",
            function () {
              var currentTime = this.wavesurfer.getCurrentTime();
              var duration = this.wavesurfer.getDuration();
              var time = moment.duration(currentTime, "seconds");

              $(".wave-cut")
                .stop(true, true)
                .animate({ width: ((currentTime + 0.25) / duration) * 100 + "%" }, 250, "linear");
              $(".progressDot")
                .stop(true, true)
                .animate({ left: ((currentTime + 0.25) / duration) * 100 + "%" }, 250, "linear");

              if (time.hours() >= 12 || time.hours() <= 0) {
                this.currentTime = moment(time.minutes() + ":" + time.seconds(), "m:s").format("mm:ss");
              } else {
                this.currentTime = moment(time.hours() + ":" + time.minutes() + ":" + time.seconds(), "h:m:s").format("h:mm:ss");
              }

              if (duration !== Infinity) {
                var totalTime = moment.duration(duration - currentTime, "seconds");
                if (totalTime.hours() >= 12 || totalTime.hours() <= 0) {
                  this.totalTime = "-" + moment(totalTime.minutes() + ":" + totalTime.seconds(), "m:s").format("mm:ss");
                } else {
                  this.totalTime = "-" + moment(totalTime.hours() + ":" + totalTime.minutes() + ":" + totalTime.seconds(), "h:m:s").format("h:mm:ss");
                }
              } else {
                this.totalTime = this.list.tracks[this.currentTrack].length;
              }
              sr_setCookieTime();
            }.bind(this)
          );
        }

        /*webAudioTouchUnlock(sonaarAudioContext).then(function (unlocked){
          if(unlocked){
            this.unlock = true
          }else{
            this.unlock = true
          }
        }.bind(this))*/

        this.setSlideVolume();
      });
    },
    watch: {
      currentTrack: function () {
        this.handleTrackChange();
      },
      isPlaying: function () {
        this.updatePlayers();
      },
      minimize: function () {
        if (this.classes.continuousPlayer) {
          sr_setCookieSettings();
        }
        this.userPref.minimize = this.minimize;
        if (this.minimize) {
          $("body").removeClass("continuousPlayer-enable");
        } else {
          $("body").addClass("continuousPlayer-enable");
        }
      },
    },
  }),
};
